<?php

return apply_filters( 'ninja_forms_available_actions', array(

    'mailchimp' => array(
        'name' => "mailchimp",
        'nicename' => "MailChimp",
        'image' => "data:image/png;base64,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",
        'link' => "https://ninjaforms.com/extensions/mail-chimp/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=MailChimp",
        'plugin_path' => "ninja-forms-mail-chimp/ninja-forms-mail-chimp.php"
    ),

    'campaignmonitor' => array(
        'name' => "campaignmonitor",
        'nicename' => "Campaign Monitor",
        'image' => "data:image/png;base64,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",
        'link' => "https://ninjaforms.com/extensions/campaign-monitor/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Campaign+Monitor",
        'plugin_path' => "ninja-forms-campaign-monitor/ninja-forms-campaign-monitor.php"
    ),

    'constantcontact' => array(
        'name' => "constantcontact",
        'nicename' => "Constant Contact",
        'image' => "data:image/png;base64,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",
        'link' => "https://ninjaforms.com/extensions/constant-contact/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Constant+Contact",
        'plugin_path' => "ninja-forms-constant-contact/ninja-forms-constant-contact.php"
    ),

    'aweber' => array(
        'name' => "aweber",
        'nicename' => "AWeber",
        'image' => "data:image/png;base64,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",
        'link' => "https://ninjaforms.com/extensions/aweber/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=AWeber",
        'plugin_path' => "ninja-forms-aweber/ninja-forms-aweber.php"
    ),

    'emma' => array(
        'name' => "emma",
        'nicename:' => "Emma",
        'image' => "data:image/png;base64,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",
        'link' => "https://ninjaforms.com/extensions/emma/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Emma",
        'plugin_path' => ""
    ),

    'slack' => array(
        'name' => "slack",
        'nicename' => "Slack",
        'image' => "data:image/png;base64,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",
        'link' => "https://ninjaforms.com/extensions/slack/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Slack",
        'plugin_path' => "ninja-forms-slack/ninja-forms-slack.php"
    ),

    'createposts' => array(
        'name' => "createposts",
        'nicename:' => "Front-End Posting",
        'image' => "data:image/png;base64,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",
        'link' => "https://ninjaforms.com/extensions/front-end-posting/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Front-End+Posting",
        'plugin_path' => "ninja-forms-post-creation/ninja-forms-post-creation.php"
    ),

    'webhook' => array(
        'name' => "webhook",
        'nicename' => "WebHook",
        'image' => "data:image/png;base64,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",
        'link' => "https://ninjaforms.com/extensions/webhooks/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Webhooks",
        'plugin_path' => "ninja-forms-webhooks/ninja-forms-webhooks.php"
    ),

    'webmerge' => array(
        'name' => "webmerge",
        'nicename' => "WebMerge",
        'image' => "data:image/png;base64,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",
        'link' => "https://ninjaforms.com/extensions/webmerge/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=WebMerge",
        'plugin_path' => "ninja-forms-webmerge/ninja-forms-webmerge.php"
    ),

    // 'helpscout' => array(
    //     'name' => "helpscout",
    //     'nicename' => "Help Scout",
    //     'image' => "",
    //     'link' => "https://ninjaforms.com/extensions/help-scout/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Help+Scout",
    //     'plugin_path' => ""
    // ),

    'zapier' => array(
        'name' => "zapier",
        'nicename' => "Zapier",
        'image' => "data:image/png;base64,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",
        'link' => "https://ninjaforms.com/extensions/zapier/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Zapier",
        'plugin_path' => "ninja-forms-zapier/ninja-forms-zapier.php"
    ),

    'file_uploads' => array(
        'name' => 'file_uploads',
        'nicename' => 'File Uploads',
        'image' => 'data:image/png;base64,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',
        'link' => 'https://ninjaforms.com/extensions/file-uploads/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=File+Uploads',
        'plugin_path' => 'ninja-forms-uploads/file-uploads.php'
    ),

    'twilio_sms' => array(
        'name' => 'twilio_sms',
        'nicename' => 'Twilio SMS',
        'image' => 'data:image/png;base64,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',
        'link' => 'https://ninjaforms.com/extensions/twilio-sms/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Twilio+SMS',
        'plugin_path' => 'ninja-forms-twilio/ninja-forms-twilio.php'
    ),

    'videomail' => array(
        'name' => 'videomail',
        'nicename' => 'Videomail',
        'image' => 'data:image/png;base64,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',
        'link' => 'https://ninjaforms.com/extensions/videomail/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Videomail',
        'plugin_path' => 'ninja-forms-videomail/ninja-forms-videomail.php'
    ),

) );
